var CKEY_W = KEY_W;
var CKEY_A = KEY_A;
var CKEY_D = KEY_D;
var CKEY_E = KEY_E;
var CKEY_F = KEY_F;
var CKEY_Q = KEY_Q;
var CKEY_Z = KEY_Z;
var CKEY_X = KEY_X;
var CKEY_SPACE = KEY_SPACE;
var CKEY_SHIFT = KEY_SHIFT;

var CKEY_1 = KEY_1;
var CKEY_2 = KEY_2;
var CKEY_3 = KEY_3;
var CKEY_4 = KEY_4;
var CKEY_5 = KEY_5;
var CKEY_6 = KEY_6;
var CKEY_7 = KEY_7;
var CKEY_8 = KEY_8;
var CKEY_9 = KEY_9;
var CKEY_0 = KEY_0;

var CMOUSE_LEFT = MOUSE_LEFT;
var CMOUSE_RIGHT = MOUSE_RIGHT;

var CKEY_ESCAPE = KEY_ESCAPE;



filey = OpenFile("keys.cfg");
CKEY_A = filey.read("a", KEY_A);
CKEY_D = filey.read("d", KEY_D);
CKEY_W = filey.read("w", KEY_W);
CKEY_E = filey.read("e", KEY_E);
CKEY_F = filey.read("f", KEY_F);
CKEY_Q = filey.read("q", 1);
CKEY_Z = filey.read("z", KEY_Z);
CKEY_X = filey.read("x", KEY_X);
CKEY_SHIFT = filey.read("shift", KEY_SHIFT);

CKEY_1 = filey.read("1", KEY_1);
CKEY_2 = filey.read("2", KEY_2);
CKEY_3 = filey.read("3", KEY_3);
CKEY_4 = filey.read("4", KEY_4);
CKEY_5 = filey.read("5", KEY_5);
CKEY_6 = filey.read("6", KEY_6);
CKEY_7 = filey.read("7", KEY_7);
CKEY_8 = filey.read("8", KEY_8);

CMOUSE_LEFT = filey.read("ml", MOUSE_LEFT);
CMOUSE_RIGHT = filey.read("mr", MOUSE_RIGHT);

msentivity = sen_min+(filey.read("sens", sen_range/2)/sen_range)*(sen_max-sen_min);
g_do_mouse_management = filey.read("dosense", 1);

filey.close();




var mouseputs = new Array();

mouseputs[MOUSE_LEFT] = "LEFT";
mouseputs[MOUSE_RIGHT] = "RIGHT"




var inputs = new Array();

inputs[KEY_ESCAPE] = "Escape";
inputs[KEY_F1] = "F1";
inputs[KEY_F2] = "F2";
inputs[KEY_F3] = "F3";
inputs[KEY_F4] = "F4";
inputs[KEY_F5] = "F5";        
inputs[KEY_F6] = "F6";
inputs[KEY_F7] = "F7";
inputs[KEY_F8] = "F8";
inputs[KEY_F9] = "F9";
inputs[KEY_F10] = "F10";
inputs[KEY_F11] = "F11";
inputs[KEY_F12] = "F12";
inputs[KEY_TILDE] = "~";
inputs[KEY_0] = "0";
inputs[KEY_1] = "1";
inputs[KEY_2] = "2";
inputs[KEY_3] = "3";
inputs[KEY_4] = "4";
inputs[KEY_5] = "5";
inputs[KEY_6] = "6";
inputs[KEY_7] = "7";
inputs[KEY_8] = "8";
inputs[KEY_9] = "9";
inputs[KEY_MINUS] = "-";
inputs[KEY_EQUALS] = "=";
inputs[KEY_BACKSPACE] = "Backspace";
inputs[KEY_TAB] = "Tab";
inputs[KEY_A] = "A";
inputs[KEY_B] = "B";
inputs[KEY_C] = "C";
inputs[KEY_D] = "D";
inputs[KEY_E] = "E";
inputs[KEY_F] = "F";
inputs[KEY_G] = "G";
inputs[KEY_H] = "H";
inputs[KEY_I] = "I";
inputs[KEY_J] = "J";
inputs[KEY_K] = "K";
inputs[KEY_L] = "L";
inputs[KEY_M] = "M";
inputs[KEY_N] = "N";
inputs[KEY_O] = "O";
inputs[KEY_P] = "P";
inputs[KEY_Q] = "Q";
inputs[KEY_R] = "R";
inputs[KEY_S] = "S";
inputs[KEY_T] = "T";
inputs[KEY_U] = "U";
inputs[KEY_V] = "V";
inputs[KEY_W] = "W";
inputs[KEY_X] = "X";
inputs[KEY_Y] = "Y";
inputs[KEY_Z] = "Z";
inputs[KEY_SHIFT] = "Shift";
inputs[KEY_CTRL] = "Control";
inputs[KEY_ALT] = "Alt";
inputs[KEY_SPACE] = "Space";
inputs[KEY_OPENBRACE] = "[";
inputs[KEY_CLOSEBRACE] = "]";
inputs[KEY_SEMICOLON] = ";";
inputs[KEY_APOSTROPHE] = "'";
inputs[KEY_COMMA] = ",";
inputs[KEY_PERIOD] = ".";
inputs[KEY_SLASH] = "/";
inputs[KEY_BACKSLASH] = "\\";
inputs[KEY_ENTER] = "Enter";
inputs[KEY_INSERT] = "Ins";
inputs[KEY_DELETE] = "Del";
inputs[KEY_HOME] = "Home";
inputs[KEY_END] = "End";
inputs[KEY_PAGEUP] = "Page Up";
inputs[KEY_PAGEDOWN] = "Page Down";
inputs[KEY_UP] = "Up";
inputs[KEY_RIGHT] = "Right";
inputs[KEY_DOWN] = "Down";
inputs[KEY_LEFT] = "Left";

var inputs2 = new Array();

inputs2[KEY_TILDE] = "~";
inputs2[KEY_0] = "0";
inputs2[KEY_1] = "1";
inputs2[KEY_2] = "2";
inputs2[KEY_3] = "3";
inputs2[KEY_4] = "4";
inputs2[KEY_5] = "5";
inputs2[KEY_6] = "6";
inputs2[KEY_7] = "7";
inputs2[KEY_8] = "8";
inputs2[KEY_9] = "9";
inputs2[KEY_MINUS] = "-";
inputs2[KEY_EQUALS] = "=";
inputs2[KEY_A] = "A";
inputs2[KEY_B] = "B";
inputs2[KEY_C] = "C";
inputs2[KEY_D] = "D";
inputs2[KEY_E] = "E";
inputs2[KEY_F] = "F";
inputs2[KEY_G] = "G";
inputs2[KEY_H] = "H";
inputs2[KEY_I] = "I";
inputs2[KEY_J] = "J";
inputs2[KEY_K] = "K";
inputs2[KEY_L] = "L";
inputs2[KEY_M] = "M";
inputs2[KEY_N] = "N";
inputs2[KEY_O] = "O";
inputs2[KEY_P] = "P";
inputs2[KEY_Q] = "Q";
inputs2[KEY_R] = "R";
inputs2[KEY_S] = "S";
inputs2[KEY_T] = "T";
inputs2[KEY_U] = "U";
inputs2[KEY_V] = "V";
inputs2[KEY_W] = "W";
inputs2[KEY_X] = "X";
inputs2[KEY_Y] = "Y";
inputs2[KEY_Z] = "Z";
inputs2[KEY_SPACE] = " ";
inputs2[KEY_OPENBRACE] = "[";
inputs2[KEY_CLOSEBRACE] = "]";
inputs2[KEY_SEMICOLON] = ";";
inputs2[KEY_APOSTROPHE] = "'";
inputs2[KEY_COMMA] = ",";
inputs2[KEY_PERIOD] = ".";
inputs2[KEY_SLASH] = "/";
inputs2[KEY_BACKSLASH] = "\\";




function LoadDefaultInput(numy)
{
	if (numy == 1)
	{
		CKEY_W = KEY_W;
		CKEY_A = KEY_A;
		CKEY_D = KEY_D;
		CKEY_E = KEY_R;
		CKEY_F = KEY_F;
		CKEY_Q = KEY_TAB;
		CKEY_Z = KEY_Q;
		CKEY_X = KEY_E;
		CKEY_SPACE = KEY_SPACE;
		CKEY_SHIFT = KEY_SHIFT;
		
		CKEY_1 = KEY_1;
		CKEY_2 = KEY_2;
		CKEY_3 = KEY_3;
		CKEY_4 = KEY_4;
		CKEY_5 = KEY_5;
		CKEY_6 = KEY_6;
		CKEY_7 = KEY_7;
		CKEY_8 = KEY_8;
		
		CMOUSE_LEFT = MOUSE_LEFT;
		CMOUSE_RIGHT = MOUSE_RIGHT;
	}
	else if (numy == 2)
	{
		CKEY_W = KEY_SPACE;
		CKEY_A = KEY_A;
		CKEY_D = KEY_D;
		CKEY_E = KEY_S;
		CKEY_F = KEY_F;
		CKEY_Q = KEY_TAB;
		CKEY_Z = KEY_Q;
		CKEY_X = KEY_W;
		CKEY_SPACE = KEY_SPACE;
		CKEY_SHIFT = KEY_SHIFT;
		
		CKEY_1 = KEY_1;
		CKEY_2 = KEY_2;
		CKEY_3 = KEY_3;
		CKEY_4 = KEY_4;
		CKEY_5 = KEY_5;
		CKEY_6 = KEY_6;
		CKEY_7 = KEY_7;
		CKEY_8 = KEY_8;
		
		CMOUSE_LEFT = MOUSE_LEFT;
		CMOUSE_RIGHT = MOUSE_RIGHT;
	}
}



function SaveKeys()
{
	//stuffs
  file = OpenFile("keys.cfg");
  file.write("a", CKEY_A);
  file.write("d", CKEY_D);
  file.write("w", CKEY_W);
  file.write("e", CKEY_E);
  file.write("f", CKEY_F);
  file.write("q", CKEY_Q);
  file.write("z", CKEY_Z);
  file.write("x", CKEY_X);
  file.write("shift", CKEY_SHIFT);

  file.write("1", CKEY_1);
  file.write("2", CKEY_2);
  file.write("3", CKEY_3);
  file.write("4", CKEY_4);
  file.write("5", CKEY_5);
  file.write("6", CKEY_6);
  file.write("7", CKEY_7);
  file.write("8", CKEY_8);

  file.write("ml", CMOUSE_LEFT);
  file.write("mr", CMOUSE_RIGHT);

	var temp = Math.round(sen_range*(msentivity-sen_min)/(sen_max-sen_min));
	file.write("sens", temp);
	file.write("dosense", g_do_mouse_management);

  file.flush();
  file.close();

}